/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************

   In this tutorial is presented how to combine extending base classes with World Manager usage

/******************************************************************************/
struct Player : Game::Chr // extend character structure by defining a player class based on the character
{
   Memx<Game::Item>  item;                          // here is the characters inventory, a container of items
   virtual _Memx*    itemContainer(){return &item;} // override default method of character, to return proper item container

           void updateItems(); // update items actions
   virtual Bool update     (); // here we'll update the player
};
/******************************************************************************/
Game::ObjMemx<Game::Static> Statics; // container for static objects
Game::ObjMemx<Game::Item  > Items  ; // container for item   objects
Game::ObjMemx<      Player> Players; // container for player objects
/******************************************************************************/
void Player::updateItems()
{
   if(Kb.bp(KB_1)) // try to pickup an item
      if(Items.elms()) // if world items container has some elements
         itemPickUp(Items[0]); // pick up the first valid item

   if(Kb.bp(KB_2)) // try to drop down an item
      if(item.elms()) // if inventory has some items
         itemDropDown(item[0]); // drop down the first item

   if(!Kb.alt)grabStop();else // if don't want to grab
   {
      if(grab.is()) // if already grabbing
      {
         Vec pos;
         SinCos(pos.z,pos.x,angle.x+PI_2); // set direction according to player angle
         pos *=ctrl.radius()+0.5;          // set radius    according to player controller radius
         pos.y=ctrl.height()*0.4;          // set vertical  position
         pos +=T.pos();
         grab.pos(pos);                    // set desired grab position
      }else
      if(Items.elms()) // if isn't grabbing anything check for presence of world items
      {
         grabStart(Items[0]); // grab first present
      }
   }
}
/******************************************************************************/
Bool Player::update()
{
   if(action)
   {
      if(Kb.b(KB_W) || Kb.b(KB_S) || Kb.b(KB_A) || Kb.b(KB_D) || Kb.b(KB_Q) || Kb.b(KB_E))actionBreak();
   }

   if(!action)
   {
      // turn & move
      input.anglei.x=Kb.b(KB_Q)-Kb.b(KB_E);
      input.anglei.y=Kb.b(KB_T)-Kb.b(KB_G);
      input.diri  .x=Kb.b(KB_D)-Kb.b(KB_A);
      input.diri  .z=Kb.b(KB_W)-Kb.b(KB_S);
      input.diri  .y=Kb.b(KB_SPACE)-Kb.b(KB_LSHIFT);

      // dodge, crouch, walk, jump
      input.dodge = Kb.bd(KB_D)-Kb.bd(KB_A);
      input.crouch= Kb.b (KB_LSHIFT);
      input.walk  = Kb.b (KB_LCTRL );
      input.jump  =(Kb.bp(KB_SPACE ) ? 3.5 : 0);

      // mouse turn
      Flt max=DegToRad(900)*Tm.d,
          dx =Ms.dir_ds.x*1.7,
          dy =Ms.dir_ds.y*1.7*Ms.inv();
      angle.x-=Mid(dx,-max,max);
      angle.y+=Mid(dy,-max,max);

      // ready stance change
      ready^=Kb.bp(KB_R);
   }

   updateItems();

   return __super::update();
}
/******************************************************************************/
void InitPre()
{
   App.name="World with Character";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024);
}
/******************************************************************************/
Bool Init()
{
   Text_ds.scale*=0.8;

   Physics.create();

   // create the world
   Game::World.init()
              .setType(Statics,OBJ_STATIC)
              .setType(Players,OBJ_CHR   ) // please note that here we'll use 'Players' memory container for 'OBJ_CHR' objects
              .setItem(Items  ,OBJ_ITEM  ) // please note that here is called 'setItem' instead of 'setType', this is used for enabling built-in character<->item relations such as picking up and dropping items
              .New("world/sample"        );

   Cam.setSpherical(Vec(16,0,16),-PI_4,-0.5,0,10).set(); // set initial camera

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   Game::World.update(Cam.at); // update world to given position

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();

   switch(Renderer())
   {
      case RM_LIGHT:
         LightDir(1,!Vec(1,-1,1)).add();
      break;
   }
}
void Draw()
{
   Renderer(Render);
                     D.text(0,0.9,"Press WSAD keys to move, 1/2 to pick up/drop item, Alt to grab");
   if(Players.elms())D.text(0,0.8,S+"Items in inventory : "+Players[0].item.elms());
}
/******************************************************************************/
